/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.language;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageElement;

public class VWLanguageList {
    private static final String[] m_languageNameArray = new String[]{VWResource.s_ISO639_Afar, VWResource.s_ISO639_Abkhazian, VWResource.s_ISO639_Afrikaans, VWResource.s_ISO639_Amharic, VWResource.s_ISO639_Arabic, VWResource.s_ISO639_Assamese, VWResource.s_ISO639_Aymara, VWResource.s_ISO639_Azerbaijani, VWResource.s_ISO639_Bashkir, VWResource.s_ISO639_Byelorussian, VWResource.s_ISO639_Bulgarian, VWResource.s_ISO639_Bihari, VWResource.s_ISO639_Bislama, VWResource.s_ISO639_Bengali, VWResource.s_ISO639_Tibetan, VWResource.s_ISO639_Breton, VWResource.s_ISO639_Catalan, VWResource.s_ISO639_Corsican, VWResource.s_ISO639_Czech, VWResource.s_ISO639_Welsh, VWResource.s_ISO639_Danish, VWResource.s_ISO639_German, VWResource.s_ISO639_Bhutani, VWResource.s_ISO639_Greek, VWResource.s_ISO639_English, VWResource.s_ISO639_Esperanto, VWResource.s_ISO639_Spanish, VWResource.s_ISO639_Estonian, VWResource.s_ISO639_Basque, VWResource.s_ISO639_Persian, VWResource.s_ISO639_Finnish, VWResource.s_ISO639_Fiji, VWResource.s_ISO639_Faeroese, VWResource.s_ISO639_French, VWResource.s_ISO639_Frisian, VWResource.s_ISO639_Irish, VWResource.s_ISO639_Gaelic, VWResource.s_ISO639_Galician, VWResource.s_ISO639_Guarani, VWResource.s_ISO639_Gujarati, VWResource.s_ISO639_Hausa, VWResource.s_ISO639_Hindi, VWResource.s_ISO639_Croatian, VWResource.s_ISO639_Hungarian, VWResource.s_ISO639_Armenian, VWResource.s_ISO639_Interlingua, VWResource.s_ISO639_Interlingue, VWResource.s_ISO639_Inupiak, VWResource.s_ISO639_Indonesian, VWResource.s_ISO639_Icelandic, VWResource.s_ISO639_Italian, VWResource.s_ISO639_Hebrew, VWResource.s_ISO639_Japanese, VWResource.s_ISO639_Yiddish, VWResource.s_ISO639_Javanese, VWResource.s_ISO639_Georgian, VWResource.s_ISO639_Kazakh, VWResource.s_ISO639_Greenlandic, VWResource.s_ISO639_Cambodian, VWResource.s_ISO639_Kannada, VWResource.s_ISO639_Korean, VWResource.s_ISO639_Kashmiri, VWResource.s_ISO639_Kurdish, VWResource.s_ISO639_Kirghiz, VWResource.s_ISO639_Latin, VWResource.s_ISO639_Lingala, VWResource.s_ISO639_Laothian, VWResource.s_ISO639_Lithuanian, VWResource.s_ISO639_Latvian, VWResource.s_ISO639_Malagasy, VWResource.s_ISO639_Maori, VWResource.s_ISO639_Macedonian, VWResource.s_ISO639_Malayalam, VWResource.s_ISO639_Mongolian, VWResource.s_ISO639_Moldavian, VWResource.s_ISO639_Marathi, VWResource.s_ISO639_Malay, VWResource.s_ISO639_Maltese, VWResource.s_ISO639_Burmese, VWResource.s_ISO639_Nauru, VWResource.s_ISO639_Nepali, VWResource.s_ISO639_Dutch, VWResource.s_ISO639_Norwegian, VWResource.s_ISO639_Occitan, VWResource.s_ISO639_Oromo, VWResource.s_ISO639_Oriya, VWResource.s_ISO639_Punjabi, VWResource.s_ISO639_Polish, VWResource.s_ISO639_Pashto, VWResource.s_ISO639_Portuguese, VWResource.s_ISO639_Quechua, VWResource.s_ISO639_RhaetoRomance, VWResource.s_ISO639_Kirundi, VWResource.s_ISO639_Romanian, VWResource.s_ISO639_Russian, VWResource.s_ISO639_Kinyarwanda, VWResource.s_ISO639_Sanskrit, VWResource.s_ISO639_Sindhi, VWResource.s_ISO639_Sangro, VWResource.s_ISO639_SerboCroatian, VWResource.s_ISO639_Singhalese, VWResource.s_ISO639_Slovak, VWResource.s_ISO639_Slovenian, VWResource.s_ISO639_Samoan, VWResource.s_ISO639_Shona, VWResource.s_ISO639_Somali, VWResource.s_ISO639_Albanian, VWResource.s_ISO639_Serbian, VWResource.s_ISO639_Siswati, VWResource.s_ISO639_Sesotho, VWResource.s_ISO639_Sudanese, VWResource.s_ISO639_Swedish, VWResource.s_ISO639_Swahili, VWResource.s_ISO639_Tamil, VWResource.s_ISO639_Tegulu, VWResource.s_ISO639_Tajik, VWResource.s_ISO639_Thai, VWResource.s_ISO639_Tigrinya, VWResource.s_ISO639_Turkmen, VWResource.s_ISO639_Tagalog, VWResource.s_ISO639_Setswana, VWResource.s_ISO639_Tonga, VWResource.s_ISO639_Turkish, VWResource.s_ISO639_Tsonga, VWResource.s_ISO639_Tatar, VWResource.s_ISO639_Twi, VWResource.s_ISO639_Ukrainian, VWResource.s_ISO639_Urdu, VWResource.s_ISO639_Uzbek, VWResource.s_ISO639_Vietnamese, VWResource.s_ISO639_Volapuk, VWResource.s_ISO639_Wolof, VWResource.s_ISO639_Xhosa, VWResource.s_ISO639_Yoruba, VWResource.s_ISO639_Chinese, VWResource.s_ISO639_Zulu};
    private static final String[] m_languageCodeArray = new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "hi", "hr", "hu", "hy", "ia", "ie", "ik", "in", "is", "it", "iw", "ja", "ji", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yo", "zh", "zu"};
    public static final int SEARCH_BY_NAME = 0;
    public static final int SEARCH_BY_CODE = 1;
    private static VWLanguageElement[] m_languageList = null;
    private static VWLanguageElement[] m_languageCodeList = null;

    public VWLanguageList() {
        VWLanguageList.checkLanguageList();
    }

    public VWLanguageElement getElementFromCode(String code) {
        VWLanguageList.checkLanguageList();
        VWLanguageElement le = this.find(code, 1);
        return le;
    }

    public VWLanguageElement getElementFromName(String name) {
        VWLanguageList.checkLanguageList();
        VWLanguageElement le = this.find(name, 0);
        return le;
    }

    public VWLanguageElement[] getLanguageList() {
        VWLanguageList.checkLanguageList();
        VWLanguageElement[] languages = null;
        if (m_languageList != null && m_languageList.length > 0) {
            languages = new VWLanguageElement[m_languageList.length];
            System.arraycopy(m_languageList, 0, languages, 0, m_languageList.length);
        }
        return languages;
    }

    public VWLanguageElement getElementAt(int index) {
        VWLanguageList.checkLanguageList();
        if (index < 0 || m_languageList == null || index > m_languageList.length) {
            return null;
        }
        VWLanguageElement elem = m_languageList[index];
        return elem;
    }

    public VWLanguageElement find(String str, int op) {
        VWLanguageList.checkLanguageList();
        if (op == 0) {
            return this.quickSearch(str, m_languageList, op, 0, m_languageNameArray.length - 1);
        }
        return this.quickSearch(str, m_languageCodeList, op, 0, m_languageNameArray.length - 1);
    }

    public void releaseResources() {
    }

    private static synchronized void checkLanguageList() {
        try {
            if (m_languageList == null) {
                int sz = m_languageNameArray.length;
                m_languageList = new VWLanguageElement[sz];
                m_languageCodeList = new VWLanguageElement[sz];
                for (int i = 0; i < sz; ++i) {
                    VWLanguageElement le;
                    VWLanguageList.m_languageList[i] = le = new VWLanguageElement(m_languageNameArray[i], m_languageCodeArray[i]);
                    VWLanguageList.m_languageCodeList[i] = le;
                }
                VWQubbleSort.sort(m_languageList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWLanguageElement quickSearch(String str, Object[] list, int op, int lo, int hi) {
        int mid = (int)((long)(lo + hi) / 2L);
        VWLanguageElement languageElem = (VWLanguageElement)list[mid];
        String searchStr = null;
        searchStr = op == 0 ? languageElem.getLanguage() : languageElem.getCode();
        int ret = str.compareToIgnoreCase(searchStr);
        if (ret == 0) {
            return languageElem;
        }
        if (ret > 0) {
            if (mid >= hi) {
                return null;
            }
            languageElem = this.quickSearch(str, list, op, mid + 1, hi);
        } else {
            languageElem = mid <= 0 ? null : this.quickSearch(str, list, op, lo, mid - 1);
        }
        return languageElem;
    }
}

